#version 330
#extension GL_EXT_gpu_shader4 : enable
// raymarch anything 3Mod01.fsh  by   Del

//https://www.shadertoy.com/view/XlKfWR
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// raymarch anything #3 - Del 14/11/2018

float pMod1(inout float p, float size)
{
	float halfsize = size*0.5;
	float c = floor((p + halfsize)/size);
	p = mod(p + halfsize, size) - halfsize;
	return c;
}

float hash(vec2 p)  // replace this by something better
{
    p  = 50.0*fract( p*0.3183099 + vec2(0.71,0.113));
    return fract( p.x*p.y*(p.x+p.y) );
}

float sdCylinder( vec3 p, vec2 h )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

float sdSphere( vec3 p, float s )
{
    return length(p)-s;
}

float smin( float a, float b, float k )
{
	float h = clamp( 0.5 + 0.5*(b-a)/k, 0.0, 1.0 );
	return mix( b, a, h ) - k*h*(1.0-h);
}

mat2 rotate(float a)
{
	float c = cos(a),
		s = sin(a);
	return mat2(c, s, -s, c);
}

float objID = 0.0;
float svobjID = 0.0;

#define	TAU 6.28318

float map(vec3 p)
{
    float time=iTime;
    float zo = time*6.75;
    float modz = mod(zo,44.0);
    
    float t2 = fract(time*1.1) * TAU;
    float t3 = fract(time*0.7) * TAU;
    float t4 = fract(time*0.14)* TAU;
    
    float m = 0.5+sin(t2+p.z*0.4)*0.5;
    m += 0.5+cos(p.z*0.4+t3+p.x*0.4)*0.5;
    
    p.xy *= rotate(p.z * .08 + t4);
    
	p.z += modz;
    float c1 = pMod1(p.z,44.0);
    
	float dist = 3.5 -abs(p.y)+m;
    
    vec3 p2 = p;
	float cz = pMod1(p2.z,4.0);
	float cx = pMod1(p2.x,4.0);

    float r = hash(vec2(cz+(cz*0.31),cx+(cx*0.61)));

    if (abs(cx)<1.0)
        r=0.0;

    if (r>0.75)
    {
		float d2 = sdCylinder(p2,vec2(0.7,5.5));         
        dist = smin(dist,d2,1.1);
    }

    objID = abs(p.z)/44.0;
    return dist;
}

vec3 normal(vec3 p)
{
	vec2 e = vec2(.001, 0.);
	vec3 n;
	n.x = map(p + e.xyy) - map(p - e.xyy);
	n.y = map(p + e.yxy) - map(p - e.yxy);
	n.z = map(p + e.yyx) - map(p - e.yyx);
	return normalize(n);
}

vec3 render(vec2 uv)
{
    float time = iTime;
	vec3 ro = vec3(0.0, 0.0, 0.0);
	vec3 rd = normalize(vec3(uv, 1.95));
	vec3 p = vec3(0.0);
	float t = 0.;
	for (int i = 0; i < 180; i++)
    {
		p = ro + rd * t;
		float d = map(p);
		if (d < .001 || t > 100.) break;
		t += .25 * d;
	}
    
    svobjID = objID;
	vec3 l = ro+vec3(0.0,0.0,12.0);
	vec3 n = normal(p);
	vec3 lp = normalize(l - p);
	float diff = 1.2 * max(dot(lp, n), 0.);
    
    vec3 c1 = vec3(2.54,2.2,1.25);
    vec3 c2 = vec3(2.54,1.1,1.85);
    
    float m = svobjID;
    vec3 col = mix(c1,c2,m);
    
	return col*diff / (1. + t * t * .01);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 q = gl_FragCoord.xy / iResolution.xy;
	vec2 uv = (2. * gl_FragCoord.xy - iResolution.xy) / iResolution.y;
	vec3 col = render(uv);
	// vignette
    col *= 0.4 + 0.6*pow( 16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y), 0.1 );
	gl_FragColor = vec4(col, 1.);
}

